<?php
/*
 * This serves to build the manual enrollment only portion of the checkout page and outputs the routing and account number fields.
 */

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}

$paynote_options = get_option('paynote_settings');

define('PAYNOTE_API_ADPOINT', $paynote_options["paynote_api_endpoint"]);

$options_paynote_recurring_cycle = isset($paynote_options['paynote_recurring_cycle']) ? $paynote_options['paynote_recurring_cycle'] : 'month';

$options_paynote_recurring_cycle = str_replace(['day', 'week', 'month3', 'month6', 'month', 'year', 'lyly', 'Monthlys'], ['Daily', 'Weekly', 'Every 3 months', 'Every 6 months', 'Monthly', 'Every year', 'ly', 'months'], $options_paynote_recurring_cycle);

$options_paynote_recurring_installments = isset($paynote_options['paynote_recurring_installments']) ? $paynote_options['paynote_recurring_installments'] : 0;

$options_paynote_recurring_installments = $options_paynote_recurring_installments ? ('for ' . esc_html($options_paynote_recurring_installments) . ' billing cycles.') : ('until canceled.');

$fields = array();

$dwolla_payment_system = ' ';
if (!empty($paynote_options['paynote_save_bank_details'])) {
    $dwolla_payment_system = '<p style="color: #737373; text-align: center; width: 75%;margin: 0 auto;" class="form-row form-row-wide">Future Payments will be processed by Paynote from the account you select. To revoke this permission, reach site administrator.</p>';
}
$paynote_gateway_description_ = 'Simply connect and verify your bank account by using your username and password to login to your online bank.';
if (!empty($paynote_options['paynote_gateway_description'])) {
    $paynote_gateway_description_ = trim($paynote_options['paynote_gateway_description']);
}

$default_fields = array(
    'payment_method' => '<p style="color: #737373; text-align: center; width: 75%;margin: 0 auto;" class="form-row form-row-wide">' . esc_html($paynote_gateway_description_) . '</p>',
    'pay-variant' => '<p>
                    <div class="account-to-account-redirect-box" style="">
                        <div class="account-to-account-redirect-icon" style="width: 200px; margin: 20px auto;">
                            <svg viewBox="-252.3 356.1 163 80.9" class="Quizd" style="height: 5.785714285714286em;">
                            <path fill="none" stroke="#939393" stroke-miterlimit="10" stroke-width="2" d="M-108.9 404.1v30c0 1.1-.9 2-2 2H-231c-1.1 0-2-.9-2-2v-75c0-1.1.9-2 2-2h120.1c1.1 0 2 .9 2 2v37m-124.1-29h124.1"></path>
                            <circle cx="-227.8" cy="361.9" r="1.8" fill="#939393"></circle>
                            <circle cx="-222.2" cy="361.9" r="1.8" fill="#939393"></circle>
                            <circle cx="-216.6" cy="361.9" r="1.8" fill="#939393"></circle>
                            <path fill="none" stroke="#939393" stroke-miterlimit="10" stroke-width="2" d="M-128.7 400.1H-92m-3.6-4.1l4 4.1-4 4.1"></path>
                            </svg>
                        </div>
                        <div class="account-to-account-redirect-message" style="width: 75%; margin: 0 auto; color: #737373; text-align: center;">
                            <p class="message">You will be redirected to your bank to complete your purchase securely.</p>
                        </div>
                        <input id="paynote-account-id" type="hidden" name="paynote_account_id"/>
                        <input id="paynote-public-token" type="hidden" name="paynote_public_token"/>
                    </div>
                  </p>',
    'recurring' => '<p style="color: #737373; text-align: center;" class="form-row form-row-wide">Recurring: ' . esc_html(ucfirst($options_paynote_recurring_cycle)) . ' ' . esc_html($options_paynote_recurring_installments) . '</p>',
    'subscription' => '<p style="color: #737373; text-align: center;" class="form-row form-row-wide">Monthly Subscription until canceled.</p>',
    'dwolla_payment_system' => $dwolla_payment_system
);

$fields = wp_parse_args($fields, apply_filters('paynote_payment_gateway_checkout_fields', $default_fields, $this->id));
?>
<fieldset id='wc-<?php echo esc_attr($this->id); ?>-check-form' class='wc-credit-card-form wc-payment-form'>
<?php
$kses_defaults = wp_kses_allowed_html( 'post' );

$svg_args = array(
    'input' => array( 
        'id' => true,
        'type' => true,
        'value' => true,
        'name' => true
    ),
    'svg'   => array(
        'class'           => true,
        'style'           => true,
        'aria-hidden'     => true,
        'aria-labelledby' => true,
        'role'            => true,
        'xmlns'           => true,
        'width'           => true,
        'height'          => true,
        'viewbox'         => true // <= Must be lower case!
    ),
    'g'     => array( 'fill' => true ),
    'title' => array( 'title' => true ),
    'circle'=> array( 
        'cx' => true,
        'r' => true,
        'fill' => true,
        'cy' => true
    ),
    'path'  => array( 
        'd'                => true,
        'stroke'           => true,
        'stroke-width'     => true,
        'stroke-miterlimit'=> true,
        'fill'             => true  
    )
);

$allowed_tags = array_merge( $kses_defaults, $svg_args );

$outputHTML = "";

if (!$this->if_recurring) {
    unset($fields['recurring'], $fields['subscription']);
} else if ($this->if_recurring == 1) {
    unset($fields['recurring']);
} else if ($this->if_recurring == 2) {
    unset($fields['subscription']);
}

foreach ($fields as $key => $field) {
    $outputHTML .= $field;
}

echo wp_kses( $outputHTML, $allowed_tags );
//echo $outputHTML;
?>
<div class='clear'></div>
</fieldset>

<?php

function paynote_checkout_plaid(){ 
   ?> 
<script>
    window.addEventListener('load', function () {

        var isOrderPayPage = window.location.pathname.includes('/checkout/order-pay/');
        window.checkoutForm = jQuery('form.woocommerce-checkout').length ? jQuery('form.woocommerce-checkout') : jQuery('form#order_review');

        if (!window.checkoutForm || window.checkoutForm.length === 0) {
            console.warn('Checkout form not found on this page.');
            return;
        }

        var successPaynoteCallback = function(public_token, metadata) { 
            if(public_token && metadata?.account_id){

                //console.log('paynote-public-token', public_token);
                //console.log('paynote-public-token', metadata.account_id);

                window.checkoutForm.find( '#paynote-public-token' ).val( public_token );
                window.checkoutForm.find( '#paynote-account-id' ).val( metadata.account_id );
                window.checkoutForm.off( isOrderPayPage ? 'submit' : 'checkout_place_order', tokenPaynoteRequest ); 

                if (isOrderPayPage) {
                    window.checkoutForm.block({ 
                        message: null, 
                        overlayCSS: {
                            background: '#fff',
                            opacity: 0.6
                        }
                    });
                }

                window.checkoutForm.submit();                
            }
            document.getElementsByTagName('html')[0].style.overflow='auto';
            window.handlerPlaidOpened = false;

        };

        var exitPaynoteCallback = function( err, metadata ) {
            document.getElementsByTagName('html')[0].style.overflow='auto';
            window.handlerPlaidOpened = false;

            if (isOrderPayPage) {
                document.querySelectorAll('.blockUI').forEach(el => el.remove());
                document.querySelectorAll('form.woocommerce-checkout, form#order_review').forEach(form => {
                    form.style.pointerEvents = '';
                    form.style.opacity = '';
                });
            }
        };

        var tokenPaynoteRequest = function() {

            if (
                window.checkoutForm.find('#paynote-public-token').val() !== '' &&
                window.checkoutForm.find('#paynote-account-id').val() !== ''
            ) {
                return true;
            }

            if (!window.handlerPlaidOpened) {
                window.handlerPlaid.open();
                window.handlerPlaidOpened = true;
            }
            return false;
        };

        if (!window.handlerPlaid) {
            
            window.handlerPlaid = Plaid.create({
                selectAccount: true,
                env: "<?php echo PAYNOTE_API_ADPOINT == PAYNOTE_ENDPOINT_LINK_LIVE ? 'production' : 'sandbox'; ?>",
                clientName: "SeamlessChex",
                apiVersion: "v2",
                token: "<?php echo getPlaidToken(); ?>",
                product: ["auth"],
                countryCodes: ["US"],
                onSuccess: successPaynoteCallback,
                onLoad: () => {},
                onExit: exitPaynoteCallback,
                onEvent: (eventName, metadata) => {}
            });
            window.handlerPlaidOpened = false;

            var pm = window.checkoutForm.find('input[type=radio][name=payment_method]:checked').val();
            window.PaynotePaymenMethod = pm == 'paynote';
            if (window.PaynotePaymenMethod) {
                window.checkoutForm.on( isOrderPayPage ? 'submit' : 'checkout_place_order',  tokenPaynoteRequest);
            }
        }

        window.checkoutForm.change(function() {
            var pm = window.checkoutForm.find('input[type=radio][name=payment_method]:checked').val();
            if (pm == 'paynote') {
                if (!window.PaynotePaymenMethod) {
                    window.PaynotePaymenMethod = true;
                    if (window.checkoutForm.find( '#paynote-public-token' ).val() !='' && window.checkoutForm.find( '#paynote-account-id' ).val() !='') {
                        window.checkoutForm.off( isOrderPayPage ? 'submit' : 'checkout_place_order',  tokenPaynoteRequest);
                    } else {
                        window.checkoutForm.on( isOrderPayPage ? 'submit' : 'checkout_place_order',  tokenPaynoteRequest);
                    }
                }
            } else {
                if (window.PaynotePaymenMethod) {
                    window.PaynotePaymenMethod = false;
                    window.checkoutForm.off( isOrderPayPage ? 'submit' : 'checkout_place_order', tokenPaynoteRequest );
                }
            }
        });
    });
</script>
<?php 
} 
add_action( 'wp_print_footer_scripts', 'paynote_checkout_plaid');

?>

