<?php

/**
 * Settings:
 *
 * Add main menu settings page for Paynote
 */

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}


function paynote_add_admin_menu() {
    add_menu_page('Paynote Settings', 'Paynote', 'manage_options', 'paynote_gateway', 'paynote_options_page', plugins_url('../img/logo-paynote.png', __FILE__), 90);
}

add_action('admin_enqueue_scripts', 'paynote_settings_js');

function paynote_settings_js($hook) {
    wp_enqueue_script( 'admin-paynote-settings-script', plugins_url('../js/admin_paynote_script.js', __FILE__), array('jquery'), PAYNOTE_VERSION, true );
}

/**
 * Settings:
 *
 * Initialize Paynote settings and values
 */
function paynote_settings_init() {
    register_setting('paynote_register_setting', 'paynote_settings', array(
        "sanitize_callback" => "paynote_settings_validate"
    ));

//********************************************************************************************** 

    add_settings_section(
            'paynote_settings_main_page',
            __("Integration Settings", 'paynote'),
            'paynote_settings_section_callback',
            'paynote_register_setting'
    );

    add_settings_field(
            'paynote_api_endpoint',
            __('Mode', 'paynote'),
            'paynote_api_endpoint_render',
            'paynote_register_setting',
            'paynote_settings_main_page'
    );

    add_settings_field(
            'paynote_live_api_key',
            __('Paynote Live Secret Key*', 'paynote'),
            'paynote_live_api_key_render',
            'paynote_register_setting',
            'paynote_settings_main_page',
            array("class" => "paynote_required paynote_validation paynoteLiveApiKey")
    );

    add_settings_field(
            'paynote_test_api_key',
            __('Paynote Test Secret Key*', 'paynote'),
            'paynote_test_api_key_render',
            'paynote_register_setting',
            'paynote_settings_main_page',
            array("class" => "paynote_required paynote_validation paynoteTestApiKey")
    );


//********************************************************************************************** 

    add_settings_section(
            'paynote_settings_order',
            __("Orders Settings", 'paynote'),
            'paynote_settings_section_callback_payment_order',
            'paynote_register_setting'
    );

    add_settings_field(
            'paynote_settings_default_order_status',
            __("Pending Order Status", 'paynote'),
            'paynote_settings_default_order_status_render',
            'paynote_register_setting',
            'paynote_settings_order',
            array("class" => "pending_default_order_status")
    );

    add_settings_field(
            'paynote_settings_order_cron',
            __("Update Order Statuses", 'paynote'),
            'paynote_settings_order_cron_render',
            'paynote_register_setting',
            'paynote_settings_order'
    );
    


//********************************************************************************************** 

    add_settings_section(
            'paynote_settings_payment_method',
            __("Checkout Settings", 'paynote'),
            'paynote_settings_section_callback_payment',
            'paynote_register_setting'
    );

    add_settings_field(
            'paynote_title',
            __('Payment Method Name*', 'paynote'),
            'paynote_title_render',
            'paynote_register_setting',
            'paynote_settings_payment_method',
            array("class" => "paynote_required paynote_validation")
    );

    add_settings_field(
            'paynote_save_bank_details',
            __('Capture Authorization Only', 'paynote'),
            'paynote_settings_save_bank_details',
            'paynote_register_setting',
            'paynote_settings_payment_method',
            array("class" => "save_bank_details")
    );

    add_settings_field(
            'paynote_recurring_cycle',
            '',
            'paynote_recurring_render',
            'paynote_register_setting',
            'paynote_settings_payment_method',
            array("class" => "hidden")
    );

    add_settings_field(
            'paynote_recurring_installments',
            '',
            'paynote_recurring_render',
            'paynote_register_setting',
            'paynote_settings_payment_method',
            array("class" => "hidden")
    );

    add_settings_field(
            'paynote_gateway_recurring',
            __('Payment Frequency', 'paynote'),
            'paynote_gateway_recurring_render',
            'paynote_register_setting',
            'paynote_settings_payment_method',
            array("class" => "payment_frequency")
    );

    add_settings_field(
            'paynote_gateway_description',
            __('Payment Method Description', 'paynote'),
            'paynote_gateway_description_render',
            'paynote_register_setting',
            'paynote_settings_payment_method'
    );

    add_settings_field(
            'paynote_extra_message',
            __('Additional Message', 'paynote'),
            'paynote_extra_message_render',
            'paynote_register_setting',
            'paynote_settings_payment_method'
    );
}

function paynote_tokenization_render() {
    
}

function paynote_recurring_render() {
    
}

function paynote_tokenization_use_render() {
    
    $options = get_option('paynote_settings');
    try {
        $options['paynote_tokenization_use'] = 0;
        update_option("paynote_settings", $options);
    } catch (Exception $e) {
        
    }
}

/**
 * Settings:
 *
 * Render the API select field in Paynote settings page
 */
function paynote_api_endpoint_render() {
    $options = get_option('paynote_settings');

    if (isset($options['paynote_api_endpoint'])) {
        if ($options['paynote_api_endpoint'] == PAYNOTE_ENDPOINT_LINK_LIVE) {
            ?>
            <select name='paynote_settings[paynote_api_endpoint]'>
                <option value='<?php echo esc_attr(PAYNOTE_ENDPOINT_LINK_LIVE) ?>' <?php selected($options['paynote_api_endpoint'], PAYNOTE_ENDPOINT_LINK_LIVE); ?>>Live</option>
                <option value='<?php echo esc_attr(PAYNOTE_ENDPOINT_LINK_TEST) ?>' <?php selected($options['paynote_api_endpoint'], PAYNOTE_ENDPOINT_LINK_TEST); ?>>Test</option>
            </select>
            <?php
        } else {
            ?>
            <select name='paynote_settings[paynote_api_endpoint]'>
                <option value='<?php echo esc_attr(PAYNOTE_ENDPOINT_LINK_TEST) ?>' <?php selected($options['paynote_api_endpoint'], PAYNOTE_ENDPOINT_LINK_TEST); ?>>Test</option>
                <option value='<?php echo esc_attr(PAYNOTE_ENDPOINT_LINK_LIVE) ?>' <?php selected($options['paynote_api_endpoint'], PAYNOTE_ENDPOINT_LINK_LIVE); ?>>Live</option>
            </select>
            <?php
        }
    } else {
        ?>
        <select name='paynote_settings[paynote_api_endpoint]'>
            <option value='<?php echo esc_attr(PAYNOTE_ENDPOINT_LINK_LIVE) ?>' selected="selected">Live</option>
            <option value='<?php echo esc_attr(PAYNOTE_ENDPOINT_LINK_TEST) ?>'>Test</option>
        </select>
        <?php
    }
}

function paynote_settings_save_bank_details() {
    $options = get_option('paynote_settings');
    if (!isset($options['paynote_save_bank_details'])) {
        $options['paynote_save_bank_details'] = 0;
    }
    ?>
    <div class="custom-control custom-switch form-check form-switch">
        <input type="checkbox" <?php checked($options['paynote_save_bank_details'], 1); ?> class="form-check-input" name="paynote_settings[paynote_save_bank_details]" id="flexSwitchCheckChecked" value="1"/>
    </div>
    <?php
}

function paynote_settings_order_cron_render() {
    $options = get_option('paynote_settings');
    $webhookurl = get_site_url() . "/wc-api/paynote_webhook/";
    ?>
    
    <select id="paynote_settings_order_cron" name='paynote_settings[paynote_settings_order_cron]'>
        <option value='0' <?php selected($options['paynote_settings_order_cron'], 0); ?>>WebHook</option>
        <option value='900' <?php selected($options['paynote_settings_order_cron'], 900); ?>>Every 15 min</option>
        <option value='1800' <?php selected($options['paynote_settings_order_cron'], 1800); ?>>Every 30 min</option>
        <option value='3600' <?php selected($options['paynote_settings_order_cron'], 3600); ?>>Every hours</option>
        <option value='86400' <?php selected($options['paynote_settings_order_cron'], 86400); ?>>Every day</option>
    </select>
    <div class="paynote_settings_webhook_block" style="display: inline-block;">
        <span style="margin-left:10px" id="paynote_settings_webhook_url">
            <strong>WebHook URL: </strong>
            <span id="webhook-url"><?php echo esc_html($webhookurl); ?></span>
            <span onclick="paynote_copyToClipboard('<?php echo esc_js($webhookurl); ?>')" class="tooltip" style="margin-left:10px">
                <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <path opacity="0.5" d="M18 2H9C7.34315 2 6 3.34315 6 5H8C8 4.44772 8.44772 4 9 4H18C18.5523 4 19 4.44772 19 5V16C19 16.5523 18.5523 17 18 17V19C19.6569 19 21 17.6569 21 16V5C21 3.34315 19.6569 2 18 2Z" fill="black"></path>
                    <path fill-rule="evenodd" clip-rule="evenodd" d="M14.7857 7.125H6.21429C5.62255 7.125 5.14286 7.6007 5.14286 8.1875V18.8125C5.14286 19.3993 5.62255 19.875 6.21429 19.875H14.7857C15.3774 19.875 15.8571 19.3993 15.8571 18.8125V8.1875C15.8571 7.6007 15.3774 7.125 14.7857 7.125ZM6.21429 5C4.43908 5 3 6.42709 3 8.1875V18.8125C3 20.5729 4.43909 22 6.21429 22H14.7857C16.5609 22 18 20.5729 18 18.8125V8.1875C18 6.42709 16.5609 5 14.7857 5H6.21429Z" fill="black"></path>
                </svg>
                <span class="tooltiptext">Copy WebHook URL</span>
            </span>
        </span>
    </div>
    <div class="paynote_settings_webhook_block paynote_webhook" style="display: flex; flex-direction: column; align-items: flex-start;">
        <div id="webhook-status-container" style="margin-top: 15px; display: none;">
            <div id="webhook-status-message" style="border: 2px solid transparent;padding: 5px 10px;border-radius: 3px;font-weight: bold;"></div>
        </div>
        <button class="button" style="display:none;margin-top: 15px;" type="button" id="set-webhook-btn" data-webhook-url="<?php echo esc_js($webhookurl); ?>">Set Webhook</button>
    </div>
    <?php
}

function paynote_settings_default_order_status_render() {
    $options = get_option('paynote_settings');
    if (!isset($options['paynote_settings_default_order_status'])) {
        $options['paynote_settings_default_order_status'] = 'on-hold';
    }
    ?>
    <select id="paynote-settings-default-order-status" name='paynote_settings[paynote_settings_default_order_status]'>
        <option value='on-hold' <?php selected($options['paynote_settings_default_order_status'], 'on-hold'); ?>>On-Hold</option>
        <option value='ach-in-process' <?php selected($options['paynote_settings_default_order_status'], 'ach-in-process'); ?>>ACH In Process</option>
    </select>
    <?php
}


function paynote_gateway_recurring_render() {
    $options = get_option('paynote_settings');
    $options_paynote_recurring_cycle = isset($options['paynote_recurring_cycle']) ? $options['paynote_recurring_cycle'] : 'month';
    $options_paynote_recurring_installments = isset($options['paynote_recurring_installments']) ? $options['paynote_recurring_installments'] : 0;
    ?>
    <table>
    	<tr>
            <td style="vertical-align:top;padding:0;">
                <select id="paynote-gateway-recurring" name='paynote_settings[paynote_gateway_recurring]'>
                    <option value='0' <?php selected($options['paynote_gateway_recurring'], 0); ?>>One Time</option>
                    <option value='1' <?php selected($options['paynote_gateway_recurring'], 1); ?>>Monthly Subscription</option>
                    <option value='2' <?php selected($options['paynote_gateway_recurring'], 2); ?>>Custom Recurring</option>
                </select>
            </td>
            <td style="vertical-align:top;padding:0 50px;">
                <div id="payt-recurring-hidden-block" class="form-row" style="display: <?php echo $options['paynote_gateway_recurring'] == 2 ? 'block' : 'none'; ?>">
                    <label style="margin-right: 10px;" for="payt-recurring-cycle"><strong>Billing Period</strong>
                        <span class="tooltip"><i class="fas fa-info-circle"></i>
                            <span class="tooltiptext">The recurring payment will occur with a selected frequency. The options available for recurring payments are daily, weekly, bi-weekly or monthly.</span>
                        </span>
                    </label>

                    <select id="payt-recurring-cycle" 
                            class="woocommerce-form__select" 
                            autocomplete="off"
                            name="paynote_settings[paynote_recurring_cycle]"> 
                        <option value="day" <?php selected($options_paynote_recurring_cycle, 'day'); ?>>Daily</option>
                        <option value="week" <?php selected($options_paynote_recurring_cycle, 'week'); ?>>Weekly</option>
                        <option value="bi-weekly" <?php selected($options_paynote_recurring_cycle, 'bi-weekly'); ?>>Bi-weekly</option>
                        <option value="month" <?php selected($options_paynote_recurring_cycle, 'month'); ?>>Monthly</option>
                    </select>
                    <br><br>
                    <label style="margin-right: 40px;" for="payt-recurring-installments"><strong>Duration</strong>
                        <span class="tooltip"><i class="fas fa-info-circle"></i><span class="tooltiptext">Submit if you require the recurring payments to occur a specific number of times or to be indefinite. 0 - indefinite (ongoing until cancelled). 1, 2, 3...N - number of recurring payments.</span></span>
                    </label>
                    <input style="max-width: 100px;" min="0" id="payt-recurring-installments" class="input-text" type="number"  autocomplete="off"  name="paynote_settings[paynote_recurring_installments]" value="<?php echo esc_html($options_paynote_recurring_installments); ?>"/> 
                </div>   			
            </td>
        </tr>
    </table>
    <?php
}

/**
 * Settings:
 *
 * Render the Client ID field in Paynote settings page
 */
function paynote_test_api_key_render() {
    $options = get_option('paynote_settings');
    $value = isset($options['paynote_test_api_key']) ? $options['paynote_test_api_key'] : "";
    echo "<input type='text' placeholder='Enter your test secret key' name='paynote_settings[paynote_test_api_key]' value='" . esc_attr($value) . "' required='required'/>";
}

/**
 * Settings:
 *
 * Render the API password field in Paynote settings page
 */
function paynote_live_api_key_render() {
    $options = get_option('paynote_settings');
    $value = isset($options['paynote_live_api_key']) ? $options['paynote_live_api_key'] : "";
    echo "<input type='text' placeholder='Enter your live secret key' name='paynote_settings[paynote_live_api_key]' value='" . esc_attr($value) . "' required='required'/>";
}

/**
 * Settings:
 *
 * Render the Title field in Paynote settings page
 */
function paynote_title_render() {
    $options = get_option('paynote_settings');
    $value = isset($options['paynote_title']) ? $options['paynote_title'] : "Pay with US Bank Account";
    echo "<input type='text' name='paynote_settings[paynote_title]' value='" . esc_attr($value) . "' required='required'/>";
}

/**
 * Settings:
 *
 * Render the Description field in Paynote settings page
 */
function paynote_gateway_description_render() {
    $options = get_option('paynote_settings');
    $value = !empty($options['paynote_gateway_description']) ? trim($options['paynote_gateway_description']) : "Connect your bank account to pay via Plaid credentialed login.";
    echo "<textarea cols='40' rows='5' name='paynote_settings[paynote_gateway_description]'>".esc_html($value)."</textarea>";
}



/**
 * Settings:
 *
 * Render the Extra message field in Paynote settings page
 */
function paynote_extra_message_render() {

    $options = get_option('paynote_settings');
    $value = isset($options['paynote_extra_message']) ? trim($options['paynote_extra_message']) : "";
    echo "<textarea cols='40' rows='5' name='paynote_settings[paynote_extra_message]'>".esc_html($value)."</textarea>";
}

/**
 * Settings:
 *
 * Insert extra text into options page
 * Left blank for aesthetic reasons
 */
function paynote_settings_section_callback() {
    $options = get_option('paynote_settings');
    echo "<hr/>";
    echo "<p><strong>Important Notice:</strong></p>";
    echo "<p>Before switching between environments, make sure you are using the correct API keys and have selected the appropriate environment (Sandbox or Live). This will help you avoid unexpected transactions or system errors.</p>";
    echo "<p><strong>Paynote offers two separate API environments to support your business operations:</strong></p>";
    echo "<ol><li><strong>Sandbox Environment</strong><p>The Sandbox environment is intended for testing and development. It allows your team to safely explore Paynote’s features using your Sandbox account — without affecting real accounts or funds.</p><p>All payments and transfers in this environment are simulated and do not involve actual money.</p></li><li><strong>Live Environment</strong><p>The Live environment is used for real financial transactions through your active Paynote account.</p><p>All debits and credits processed here involve real money and are directly reflected in your connected bank account.</p></li></ol>";
    
}


function paynote_settings_section_callback_payment() {
    echo "<hr/>";
    echo "<p>Customize how do you want Paynote to be displayed on your store’s checkout page.</p>";
}

function paynote_settings_section_callback_payment_order() {
    echo "<hr/>";
    echo "<p><strong>Setting Up Webhooks for Order Status Sync</strong></p>";
    echo "<ol><li>In the <strong>Order Settings</strong> section, next to the <strong>Update Order Statuses</strong> option, select <strong>WebHook</strong> from the dropdown menu.</li><li>Paste the webhook URL into the Webhook URL field in the <a href='https://paynote.seamlesschex.com/#/account/api' target='_blank'>Paynote portal</a>.</li><li>If you encounter error when saving Webhook URL into Paynote portal, refer to the <a href='https://docs.paynote.io/docs/how-to-sync-order-statuses-between-paynote-and-your-woocommerce-store-using-webhooks#common-webhook-issues-and-solutions' target='_blank'>Common Webhook Issues and Solutions</a>.</li></ol>";
    echo "<p><strong>Understanding WooCommerce Order Statuses with ACH Payments</strong></p><p style='max-width: 60%;'>By default, WooCommerce sets all payments to <strong>On-Hold</strong> as soon as they are initiated. We’ve added a custom status called <strong>ACH In Process</strong>, which indicates that the customer has started the payment, but it has not yet settled. Once the payment settles, WooCommerce changes the status to <strong>Processing</strong>, meaning the payment has been received, stock has been reduced, and the order is awaiting fulfillment. The status <strong>Failed</strong> indicates that the payment did not process successfully. For more information, refer to WooCommerce’s <a href='https://woocommerce.com/document/managing-orders/order-statuses/' target='_blank'>Order Statuses documentation</a></strong>.</p>";
    echo "<p>The statuses for Payment Webhooks are described in our <a href='https://docs.paynote.io/docs/payment-webhooks' target='_blank'>documentation</a>.</p>";
    echo "<p><strong>Configuring Email Notifications for ACH Payments</strong></p><p style='max-width: 60%;'>Paynote integrates its ACH order statuses with WooCommerce email notifications, allowing you to keep your customers informed throughout the payment process. You can configure these email settings directly in your site admin panel. Detailed setup instructions are available in our <a href='https://docs.paynote.io/docs/email-notifications-paynote-ach-status-integration-with-woocommerce#%EF%B8%8F-editing-emails' target='_blank'>documentation</a>.</p><p><strong>Important Note:</strong></p><p>These email templates are disabled by default after plugin installation.</p>";
    echo "<br>";
}

function paynote_settings_validate($settings) {
    require_once("gateway.php");

    $oldOptions = get_option('paynote_settings');
    if (!isset($settings['paynote_test_api_key']) || strlen($settings['paynote_test_api_key']) === 0) {
        add_settings_error("paynote_settings", "paynote_test_api_key", "Paynote Pay API Client ID can't be empty. Settings have been reverted.");
        $settings["paynote_test_api_key"] = $oldOptions["paynote_test_api_key"];
        return $settings;
    }

    if (!isset($settings['paynote_live_api_key']) || strlen($settings['paynote_live_api_key']) === 0) {
        add_settings_error("paynote_settings", "paynote_live_api_key", "Paynote Pay API Password can't be empty. Settings have been reverted.");
        $settings["paynote_live_api_key"] = $oldOptions["paynote_live_api_key"];
        return $settings;
    }

    return $settings;
}

function paynote_getPublicKey($options) {
    if ($options["paynote_api_endpoint"] == PAYNOTE_ENDPOINT_LINK_LIVE) {
        echo esc_html($options["paynote_live_api_public_key"]);
    } else {
        echo esc_html($options["paynote_test_api_public_key"]);
    }
}

/**
 * Settings:
 *
 * Main function to inject settings into wordpress admin menu
 */
function paynote_options_page() {
    ?>
    <form action='options.php' method='post'>
        <h1>Paynote Plugin</h1>
        <br>
        <p style="font-weight:600;">Instructions: <a href="https://docs-paynote.seamlesschex.com/" target="_blank" title="Paynote REST API">Paynote REST API</a></p>
        <p style="font-weight:600;">For assistance, email <a href="mailto:paynote@seamlesschex.com" title="paynote@seamlesschex.com">paynote@seamlesschex.com</a></p>
        <br>
        <?php
        settings_errors();
        settings_fields('paynote_register_setting');
        do_settings_sections('paynote_register_setting');
        submit_button('Save Changes', 'primary', 'paynote_submit');
        ?>
    </form>
    <?php
}

add_action('admin_menu', 'paynote_add_admin_menu');
add_action('admin_init', 'paynote_settings_init');
?>