jQuery(document).ready(function($) {
    console.log('load admin script...')
    $('#paynote_submit').click(function() {
        var required = $('.paynote_required').find('input, textarea, select');
        for (var i = 0; i < required.length; i++) {
            var input = $(required[i]);
            if (!paynote_checkvalid(input, true)) {
                return false;
            }
        }
    });

    $('.paynote_validation input, g.paynote_validation textarea').blur(function() {
        var input = $(this);
        paynote_checkvalid(input, false);
    });

    var pending_default_order_status = $('.pending_default_order_status th').text();
    if (pending_default_order_status) {
        $('.pending_default_order_status th').html(
            pending_default_order_status +
            '<span class="tooltip"><svg xmlns="http://www.w3.org/2000/svg"  viewBox="0 0 50 50" width="15px" height="15px"><path d="M 25 2 C 12.309295 2 2 12.309295 2 25 C 2 37.690705 12.309295 48 25 48 C 37.690705 48 48 37.690705 48 25 C 48 12.309295 37.690705 2 25 2 z M 25 4 C 36.609824 4 46 13.390176 46 25 C 46 36.609824 36.609824 46 25 46 C 13.390176 46 4 36.609824 4 25 C 4 13.390176 13.390176 4 25 4 z M 25 11 A 3 3 0 0 0 22 14 A 3 3 0 0 0 25 17 A 3 3 0 0 0 28 14 A 3 3 0 0 0 25 11 z M 21 21 L 21 23 L 22 23 L 23 23 L 23 36 L 22 36 L 21 36 L 21 38 L 22 38 L 23 38 L 27 38 L 28 38 L 29 38 L 29 36 L 28 36 L 27 36 L 27 21 L 26 21 L 22 21 L 21 21 z"/></svg><span class="tooltiptext">Select the initial status for newly created orders. Choose ‘On Hold’ or ‘ACH In Process’ to indicate that the order payment is currently being processed. This status is automatically assigned to the order when it is first created based on your selection.</span></span>',
        );
    }

    var paynoteLiveApiKey = $('.paynoteLiveApiKey th').text();
    if (paynoteLiveApiKey) {
        $('.paynoteLiveApiKey th').html(
            paynoteLiveApiKey +
            '<span class="tooltip"><svg xmlns="http://www.w3.org/2000/svg"  viewBox="0 0 50 50" width="15px" height="15px"><path d="M 25 2 C 12.309295 2 2 12.309295 2 25 C 2 37.690705 12.309295 48 25 48 C 37.690705 48 48 37.690705 48 25 C 48 12.309295 37.690705 2 25 2 z M 25 4 C 36.609824 4 46 13.390176 46 25 C 46 36.609824 36.609824 46 25 46 C 13.390176 46 4 36.609824 4 25 C 4 13.390176 13.390176 4 25 4 z M 25 11 A 3 3 0 0 0 22 14 A 3 3 0 0 0 25 17 A 3 3 0 0 0 28 14 A 3 3 0 0 0 25 11 z M 21 21 L 21 23 L 22 23 L 23 23 L 23 36 L 22 36 L 21 36 L 21 38 L 22 38 L 23 38 L 27 38 L 28 38 L 29 38 L 29 36 L 28 36 L 27 36 L 27 21 L 26 21 L 22 21 L 21 21 z"/></svg><span class="tooltiptext">Paste your secret key from your Live <a href="https://paynote.seamlesschex.com/#/account/api" target="_blank" title="Paynote account">Paynote account</a></span></span>',
        );
    }

    var paynoteTestApiKey = $('.paynoteTestApiKey th').text();
    if (paynoteTestApiKey) {
        $('.paynoteTestApiKey th').html(
            paynoteTestApiKey +
            '<span class="tooltip"><svg xmlns="http://www.w3.org/2000/svg"  viewBox="0 0 50 50" width="15px" height="15px"><path d="M 25 2 C 12.309295 2 2 12.309295 2 25 C 2 37.690705 12.309295 48 25 48 C 37.690705 48 48 37.690705 48 25 C 48 12.309295 37.690705 2 25 2 z M 25 4 C 36.609824 4 46 13.390176 46 25 C 46 36.609824 36.609824 46 25 46 C 13.390176 46 4 36.609824 4 25 C 4 13.390176 13.390176 4 25 4 z M 25 11 A 3 3 0 0 0 22 14 A 3 3 0 0 0 25 17 A 3 3 0 0 0 28 14 A 3 3 0 0 0 25 11 z M 21 21 L 21 23 L 22 23 L 23 23 L 23 36 L 22 36 L 21 36 L 21 38 L 22 38 L 23 38 L 27 38 L 28 38 L 29 38 L 29 36 L 28 36 L 27 36 L 27 21 L 26 21 L 22 21 L 21 21 z"/></svg><span class="tooltiptext">Paste your secret key from your <a href="https://paynote-sandbox.seamlesschex.com/#/account/api" target="_blank" title="Paynote Sandbox account">Paynote Sandbox account</a></span></span>',
        );
    }

    var capture = $('.save_bank_details th').text();
    if (capture) {
        $('.save_bank_details th').html(
            capture +
            '<span class="tooltip"><svg xmlns="http://www.w3.org/2000/svg"  viewBox="0 0 50 50" width="15px" height="15px"><path d="M 25 2 C 12.309295 2 2 12.309295 2 25 C 2 37.690705 12.309295 48 25 48 C 37.690705 48 48 37.690705 48 25 C 48 12.309295 37.690705 2 25 2 z M 25 4 C 36.609824 4 46 13.390176 46 25 C 46 36.609824 36.609824 46 25 46 C 13.390176 46 4 36.609824 4 25 C 4 13.390176 13.390176 4 25 4 z M 25 11 A 3 3 0 0 0 22 14 A 3 3 0 0 0 25 17 A 3 3 0 0 0 28 14 A 3 3 0 0 0 25 11 z M 21 21 L 21 23 L 22 23 L 23 23 L 23 36 L 22 36 L 21 36 L 21 38 L 22 38 L 23 38 L 27 38 L 28 38 L 29 38 L 29 36 L 28 36 L 27 36 L 27 21 L 26 21 L 22 21 L 21 21 z"/></svg><span class="tooltiptext">Enable to capture auth to save customer bank details for future debits. No transaction is created when this is selected.</span></span>',
        );
    }

    var payment_frequency = $('.payment_frequency th').text();
    if (payment_frequency) {
        $('.payment_frequency th').html(
            payment_frequency +
            '<span class="tooltip"><svg xmlns="http://www.w3.org/2000/svg"  viewBox="0 0 50 50" width="15px" height="15px"><path d="M 25 2 C 12.309295 2 2 12.309295 2 25 C 2 37.690705 12.309295 48 25 48 C 37.690705 48 48 37.690705 48 25 C 48 12.309295 37.690705 2 25 2 z M 25 4 C 36.609824 4 46 13.390176 46 25 C 46 36.609824 36.609824 46 25 46 C 13.390176 46 4 36.609824 4 25 C 4 13.390176 13.390176 4 25 4 z M 25 11 A 3 3 0 0 0 22 14 A 3 3 0 0 0 25 17 A 3 3 0 0 0 28 14 A 3 3 0 0 0 25 11 z M 21 21 L 21 23 L 22 23 L 23 23 L 23 36 L 22 36 L 21 36 L 21 38 L 22 38 L 23 38 L 27 38 L 28 38 L 29 38 L 29 36 L 28 36 L 27 36 L 27 21 L 26 21 L 22 21 L 21 21 z"/></svg><span class="tooltiptext">Set one-time or recurring payments. Configure your payment setup.</span></span>',
        );
    }

    jQuery('#paynote-gateway-recurring').change(function() {
        var sel = jQuery(this).find(':selected').val();
        if (sel == 1) {
            jQuery('#payt-recurring-cycle').val('Month');
            jQuery('#payt-recurring-installments').val('0');
            jQuery('#payt-recurring-hidden-block').hide();
        } else if (sel == 2) {
            jQuery('#payt-recurring-hidden-block').show();
        } else {
            jQuery(this).val('0');
            jQuery('#payt-recurring-cycle').val('');
            jQuery('#payt-recurring-installments').val('0');
            jQuery('#payt-recurring-hidden-block').hide();
        }
    });

    if (jQuery('#paynote_settings_order_cron').val() != 0) {
        jQuery('#paynote_settings_webhook_url').hide();
    } else {
        jQuery('#paynote_settings_webhook_url').show();
    }

    jQuery('#paynote_settings_order_cron').change(function() {
        if (jQuery(this).val() != 0) {
            jQuery('.paynote_settings_webhook_block').hide();
        } else {
            jQuery('.paynote_settings_webhook_block').show();
        }
    });

    function getEnvironmentLabel() {
        const envText = jQuery('select[name="paynote_settings[paynote_api_endpoint]"] option:selected').text().trim();
        return (envText === 'Live') ? 'Live (Production)' : 'Test (Sandbox)';
    }

    jQuery('#set-webhook-btn').click(function() {
        var btn = jQuery(this);
        var url = btn.data('webhook-url');

        jQuery.ajax(ajaxurl, {
            type: "post",
            data: {
                action: 'paynote_set_webhook',
                url: url,
                _ajax_nonce: ajax_object_name.security
            },
            beforeSend: function() {
                btn.append('<div id="loading-set" style="display:inline;margin:3px"><img src="images/loading.gif" title="loading" /></div>');
                btn.prop('disabled', true);
                jQuery('#webhook-status-container').show();
                jQuery('#webhook-status-message').html('Checking webhook...').css({
                    borderColor: '#999',
                    color: '#333'
                });
            },
            success: function(response) {
                const environment = getEnvironmentLabel();
                if (!response.webhook_url) {
                    jQuery('#webhook-status-message').text('Webhook is not set in '+ environment +'.').css({
                        borderColor: 'red',
                        color: 'red'
                    });
                    jQuery('#set-webhook-btn').show();
                    return;
                }
                
                const isMatch = response.webhook_url === url;

                if (isMatch) {
                    jQuery('#webhook-status-message').text('Webhook is correctly set in '+ environment +'.').css({
                        borderColor: 'green',
                        color: 'green'
                    });
                    jQuery('#set-webhook-btn').hide();
                } else {
                    jQuery('#webhook-status-message').html(
                    '⚠️ Webhook mismatch detected.<br>' +
                    '<span style="color:black;font-weight:500;"><strong>Expected '+ environment +':</strong> ' + url + '</span><br>' +
                    '<span style="color:black;font-weight:500;"><strong>Current '+ environment +':</strong> ' + response.webhook_url + '</span>'
                ).css({
                    borderColor: 'orange',
                    color: 'orange'
                });
                jQuery('#set-webhook-btn').show();
                }
            },
            complete: function() {
                btn.find('#loading-set').remove();
                btn.prop('disabled', false);
            },
            error: function(err) {
                console.log("Error: " + err.status + " " + err.statusText);
                //alert('❌ Network error');
            }
        });
    });

    var expectedUrl = ajax_object_name.expected_webhook_url;

    jQuery.ajax(ajaxurl, {
        type: "get",
        data: {
            action: 'paynote_get_webhook',
            _ajax_nonce: ajax_object_name.security
        },
        beforeSend: function() {
            jQuery('#webhook-status-container').show();
            jQuery('#webhook-status-message').html('Checking webhook...').css({
                borderColor: '#999',
                color: '#333'
            });
            jQuery('#set-webhook-btn').hide();
        },
        success: function(response) {
            const environment = getEnvironmentLabel();
            if (!response.webhook_url) {
                jQuery('#webhook-status-message').text('Webhook is not set in '+ environment +'.').css({
                    borderColor: 'red',
                    color: 'red'
                });
                jQuery('#set-webhook-btn').show();
                return;
            }
            
            const isMatch = response.webhook_url === expectedUrl;

            if (isMatch) {
                jQuery('#webhook-status-message').text('Webhook is correctly set in '+ environment +'.').css({
                    borderColor: 'green',
                    color: 'green'
                });
                jQuery('#set-webhook-btn').hide();
            } else {
                jQuery('#webhook-status-message').html(
                    '⚠️ Webhook mismatch detected.<br>' +
                    '<span style="color:black;font-weight:500;"><strong>Expected '+ environment +':</strong> ' + expectedUrl + '</span><br>' +
                    '<span style="color:black;font-weight:500;"><strong>Current '+ environment +':</strong> ' + response.webhook_url + '</span>'
                ).css({
                    borderColor: 'orange',
                    color: 'orange'
                });
                jQuery('#set-webhook-btn').show();
            }
        },
        error: function(err) {
            console.log("Error: " + err.status + " " + err.statusText);
            jQuery('#webhook-status-message').text('Network error during webhook check.').css({
                borderColor: 'red',
                color: 'red'
            });
            jQuery('#set-webhook-btn').show();
        }
    });

});

function paynote_checkvalid(input, scrollTo) {
    if (scrollTo !== true) scrollTo = false;

    if (jQuery(input).val().trim().length === 0) {
        jQuery(input)[0].setCustomValidity('Required');
        if (scrollTo) {
            jQuery(input)[0].scrollIntoView({
                behavior: 'smooth',
                block: 'center',
            });
        }
        return false;
    } else {
        jQuery(input)[0].setCustomValidity('');
        return true;
    }
}



function paynote_copyToClipboard(text) {
    console.log('WebHook Copyed');
    if (window.clipboardData && window.clipboardData?.setData) {
        return window.clipboardData?.setData('Text', text);
    } else if (document.queryCommandSupported && document.queryCommandSupported('copy')) {
        var textarea = document.createElement('textarea');
        textarea.textContent = text;
        textarea.style.position = 'fixed';
        document.body.appendChild(textarea);
        textarea.select();
        try {
            return document.execCommand('copy');
        } catch (ex) {
            console.warn('Copy to clipboard failed.', ex);
            return prompt('Copy to clipboard: Ctrl+C, Enter', text);
        } finally {
            document.body.removeChild(textarea);
        }
    }
}