const { useEffect } = window.wp.element;
const { registerPaymentMethod } = window.wc.wcBlocksRegistry;

const settings = window.wc.wcSettings.getSetting( 'paynote_data', {} );
const label = window.wp.htmlEntities.decodeEntities( settings.title ) || window.wp.i18n.__( 'Paynote', 'paynote' );

const labelLogo = React.createElement('div', {class: 'paynote-radio-control-box'},
    React.createElement('img', {
        src: settings.icon,
        alt: settings.title,
        style: { marginRight: '0.5em' },
        class: 'paynote-icon-blocks'
        }
    ), React.createElement('span', {class: 'paynote-title-blocks'}, settings.title));

const PaynoteAccountId = React.createElement('input', {type: 'hidden', id: 'paynote_account_id', name: 'paynote_account_id'});
const PaynotePublicToken = React.createElement('input', {type: 'hidden', id: 'paynote_public_token', name: 'paynote_public_token'});
const PaynoteAccountText = React.createElement('input', {style: {display:'none'}, type: 'text', id: 'paynote_account_text', name: 'paynote_account_text', placeholder: 'Your chosen bank account', disabled:true}); 

const paynoteContent = (props) => {

    const { eventRegistration, emitResponse } = props;
    const { onPaymentSetup } = eventRegistration;
    
    useEffect( () => {

        const unsubscribe = onPaymentSetup( async () => {

            const pt = PaynotePublicToken.value;
            const pai = PaynoteAccountId.value;
            
            if ( pt ) {
                return {
                    type: emitResponse.responseTypes.SUCCESS,
                    meta: {
                        paymentMethodData: {
                            paynote_account_id:pai, 
                            paynote_public_token:pt
                        }
                    }
                };
            }

        } );

        return () => {
            unsubscribe();
        };
    }, [] );

      return  React.createElement('div', {id: 'paynote-additional-fields'},
            React.createElement('div', { class: 'paynote-btn-wraper'},
            React.createElement('p', { class: 'paynote-description-text'}, window.wp.htmlEntities.decodeEntities(settings.description || 'Securely link your bank for quick, seamless payments.')),
            PaynoteAccountText,
            React.createElement('span', {class: 'paynote-checkout-button', onClick: handleSubmitVerification}, 'Add bank account')
            ),
            PaynoteAccountId,
            PaynotePublicToken
        );     
    
};

const handleSubmitVerification = (event) => {
    window.tokenPaynoteRequestBlocks();
};

const Block_Paynote_Payment_Gateway = {
    name: 'paynote',
    label: labelLogo,
    content: Object( window.wp.element.createElement )( paynoteContent, null ),
    edit: Object( window.wp.element.createElement )( paynoteContent, null ),
    canMakePayment: () => true,
    ariaLabel: label,
    supports: {
        features: settings.supports,
    },
};

registerPaymentMethod( Block_Paynote_Payment_Gateway );

if (window.wc && window.wc.wcBlocksRegistry && settings?.plaid_key) {

    window.addEventListener('load', function() {        

        window.successPaynoteCallbackBlocks = function(public_token, metadata) { 
            if (public_token && metadata?.account_id){

                PaynoteAccountId.value = metadata.account_id;
                PaynotePublicToken.value = public_token;
                var account_text_width = ((metadata.institution.name + ' ****' + metadata.account.mask).toString().length * 9) + 50 + "px";

                document.getElementById('paynote_account_text').value = metadata.institution.name + ' ****' + metadata.account.mask;
                document.getElementById('paynote_account_text').style = {display:'block'};
                document.getElementById('paynote_account_text').style.width = account_text_width;         
            }   
            document.getElementsByTagName('html')[0].style.overflow='auto';
            window.handlerPlaidOpenedBlocks = false;
        };

        if (!window.handlerPlaidBlocks) {
           
                window.handlerPlaidBlocks = Plaid.create({
                    selectAccount: true,
                    env: settings.plaid_env,
                    clientName: "SeamlessChex",
                    apiVersion: "v2",
                    token: settings.plaid_key,
                    product: ["auth"],
                    countryCodes: ["US"],
                    onSuccess: window.successPaynoteCallbackBlocks,
                    onLoad: () => {},
                    onExit: () => {},
                    onEvent: (eventName, metadata) => {
                        if (eventName == 'EXIT') {
                            document.getElementsByTagName('html')[0].style.overflow='auto';       
                            window.handlerPlaidOpenedBlocks = false;
                        }
                    }
                });   

            window.handlerPlaidOpenedBlocks = false;

            window.tokenPaynoteRequestBlocks = function() {
                if (!window.handlerPlaidOpenedBlocks) {
                    window.handlerPlaidBlocks.open();
                    window.handlerPlaidOpenedBlocks = true;
                }
                return false;
            };
        }
    });
}