<?php
use Automattic\WooCommerce\Blocks\Payments\Integrations\AbstractPaymentMethodType;

final class Woocommerce_Gateway_Paynote_Blocks extends AbstractPaymentMethodType {

    private $gateway;
    protected $name = 'paynote';// block payment gateway name

    public function initialize() {
        require_once plugin_dir_path(__FILE__) . 'includes/gateway.php';
        $this->settings = get_option( 'paynote_settings', [] );
        $this->gateway = new WC_Gateway_Paynote();
    }

    public function is_active() {
        return $this->gateway->is_available();
    }

    public function register_blocks() {
        add_action('init', function () {
            register_block_type('wc/paynote-block', array(
                'render_callback' => array($this, 'render_block_for_order_pay'),
            ));
        });
    }

    public function render_block_for_order_pay($attributes) {
        return '<div id="wc-paynote-block">Paynote Block Content</div>';
    }

    public function get_payment_method_script_handles() {
        wp_register_script(
            'wc-gateway-paynote-blocks-integration',
            plugin_dir_url(__FILE__) . 'js/checkout.js',
            [
                'wc-blocks-registry',
                'wc-settings',
                'wp-element',
                'wp-html-entities',
                'wp-i18n',
            ],
            null,
            true
        );
        if( function_exists( 'wp_set_script_translations' ) ) {            
            wp_set_script_translations( 'wc-gateway-paynote-blocks-integration');
            
        }
        return [ 'wc-gateway-paynote-blocks-integration' ];
    }
    
    public function get_payment_method_data() {
        return [
            'title' => $this->gateway->title,
            'description' => $this->gateway->description,
            'icon'  => apply_filters('wc_gateway_paynote_icon', plugins_url('img/logo-paynoteX2.png', __FILE__)),
            'plaid_key' => getPlaidToken(),
            'plaid_env' => PAYNOTE_DEBUG ? "sandbox" : ($this->gateway->endpoint == PAYNOTE_ENDPOINT_LINK_LIVE ? "production" : "sandbox")
        ];
    }
}